import { HashRouter as Router, Routes, Route, NavLink } from 'react-router-dom';
import Header from '@arcwp/gateway-admin';
import Dashboard from './pages/Dashboard';
import Collections from './pages/Collections';
import CollectionDetail from './pages/CollectionDetail';
import Settings from './pages/Settings';
import Chat from './pages/Chat';

import { useEffect } from 'react';

function App() {
  useEffect(() => {
    const menu = document.querySelector('.gty-admin-header');
    if (!menu) return;
    let scrollTimeout;
    const onScroll = () => {
      menu.classList.add('gty-admin-header--scrolling');
      clearTimeout(scrollTimeout);
      scrollTimeout = setTimeout(() => {
        menu.classList.remove('gty-admin-header--scrolling');
      }, 120);
    };
    window.addEventListener('scroll', onScroll);
    return () => {
      window.removeEventListener('scroll', onScroll);
      clearTimeout(scrollTimeout);
    };
  }, []);

  return (
    <Router>
      <div className="gty-admin-app">
        <Header>
          <Header.Logo>
            <NavLink
              to="/"
              className={({ isActive }) =>
                [
                  'gty-admin-header__title',
                  'gty-admin-link',
                  isActive ? 'gty-admin-header__title--active' : ''
                ].join(' ')
              }
            >
              GATEWAY
            </NavLink>
          </Header.Logo>
          <Header.Menu>
            <NavLink
              to="/collections"
              className={({ isActive }) =>
                [
                  'gty-admin-header-menu__link',
                  'gty-admin-link',
                  isActive ? 'gty-admin-header-menu__link--active' : ''
                ].join(' ')
              }
            >
              Collections
            </NavLink>
          </Header.Menu>
          <Header.Buttons>
            <NavLink
              to="/settings"
              className="gty-admin-header__icon gty-admin-link"
              aria-label="Settings"
            >
              <svg className="gty-admin-header__icon-svg" width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g clipPath="url(#clip0_747_81)">
                  <path d="M10 12.5C11.3807 12.5 12.5 11.3807 12.5 10C12.5 8.61929 11.3807 7.5 10 7.5C8.61929 7.5 7.5 8.61929 7.5 10C7.5 11.3807 8.61929 12.5 10 12.5Z" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                  <path d="M16.1666 12.5C16.0557 12.7514 16.0226 13.0302 16.0716 13.3005C16.1207 13.5708 16.2495 13.8203 16.4416 14.0167L16.4916 14.0667C16.6466 14.2215 16.7695 14.4053 16.8534 14.6076C16.9373 14.8099 16.9805 15.0268 16.9805 15.2458C16.9805 15.4649 16.9373 15.6817 16.8534 15.8841C16.7695 16.0864 16.6466 16.2702 16.4916 16.425C16.3369 16.58 16.153 16.7029 15.9507 16.7868C15.7484 16.8707 15.5315 16.9138 15.3125 16.9138C15.0935 16.9138 14.8766 16.8707 14.6742 16.7868C14.4719 16.7029 14.2881 16.58 14.1333 16.425L14.0833 16.375C13.8869 16.1829 13.6375 16.054 13.3671 16.005C13.0968 15.956 12.818 15.9891 12.5666 16.1C12.3202 16.2056 12.11 16.381 11.9619 16.6046C11.8138 16.8282 11.7344 17.0902 11.7333 17.3583V17.5C11.7333 17.942 11.5577 18.366 11.2452 18.6785C10.9326 18.9911 10.5087 19.1667 10.0666 19.1667C9.62462 19.1667 9.2007 18.9911 8.88814 18.6785C8.57558 18.366 8.39998 17.942 8.39998 17.5V17.425C8.39353 17.1492 8.30425 16.8817 8.14374 16.6573C7.98323 16.4328 7.75893 16.2619 7.49998 16.1667C7.24863 16.0557 6.96982 16.0227 6.69949 16.0717C6.42916 16.1207 6.17971 16.2496 5.98331 16.4417L5.93331 16.4917C5.77852 16.6466 5.59471 16.7696 5.39238 16.8534C5.19005 16.9373 4.97317 16.9805 4.75415 16.9805C4.53512 16.9805 4.31824 16.9373 4.11591 16.8534C3.91358 16.7696 3.72977 16.6466 3.57498 16.4917C3.42002 16.3369 3.29709 16.1531 3.21321 15.9507C3.12934 15.7484 3.08617 15.5315 3.08617 15.3125C3.08617 15.0935 3.12934 14.8766 3.21321 14.6743C3.29709 14.4719 3.42002 14.2881 3.57498 14.1333L3.62498 14.0833C3.81709 13.8869 3.94597 13.6375 3.99498 13.3672C4.044 13.0968 4.01091 12.818 3.89998 12.5667C3.79434 12.3202 3.61894 12.11 3.39537 11.9619C3.17179 11.8139 2.9098 11.7344 2.64165 11.7333H2.49998C2.05795 11.7333 1.63403 11.5577 1.32147 11.2452C1.00891 10.9326 0.833313 10.5087 0.833313 10.0667C0.833313 9.62465 1.00891 9.20073 1.32147 8.88817C1.63403 8.57561 2.05795 8.40001 2.49998 8.40001H2.57498C2.85081 8.39356 3.11832 8.30428 3.34273 8.14377C3.56714 7.98326 3.73808 7.75896 3.83331 7.50001C3.94424 7.24866 3.97733 6.96985 3.92832 6.69952C3.8793 6.42919 3.75043 6.17974 3.55831 5.98334L3.50831 5.93334C3.35335 5.77856 3.23042 5.59474 3.14655 5.39241C3.06267 5.19008 3.0195 4.9732 3.0195 4.75418C3.0195 4.53515 3.06267 4.31827 3.14655 4.11594C3.23042 3.91361 3.35335 3.7298 3.50831 3.57501C3.6631 3.42005 3.84692 3.29712 4.04925 3.21324C4.25158 3.12937 4.46845 3.0862 4.68748 3.0862C4.90651 3.0862 5.12338 3.12937 5.32571 3.21324C5.52804 3.29712 5.71186 3.42005 5.86665 3.57501L5.91665 3.62501C6.11305 3.81712 6.36249 3.946 6.63282 3.99501C6.90315 4.04403 7.18197 4.01094 7.43331 3.90001H7.49998C7.74645 3.79437 7.95666 3.61897 8.10472 3.3954C8.25279 3.17182 8.33224 2.90983 8.33331 2.64168V2.50001C8.33331 2.05798 8.50891 1.63406 8.82147 1.3215C9.13403 1.00894 9.55795 0.833344 9.99998 0.833344C10.442 0.833344 10.8659 1.00894 11.1785 1.3215C11.4911 1.63406 11.6666 2.05798 11.6666 2.50001V2.57501C11.6677 2.84317 11.7472 3.10516 11.8952 3.32873C12.0433 3.55231 12.2535 3.72771 12.5 3.83334C12.7513 3.94427 13.0301 3.97736 13.3005 3.92835C13.5708 3.87933 13.8202 3.75046 14.0166 3.55834L14.0666 3.50834C14.2214 3.35338 14.4052 3.23045 14.6076 3.14658C14.8099 3.0627 15.0268 3.01953 15.2458 3.01953C15.4648 3.01953 15.6817 3.0627 15.884 3.14658C16.0864 3.23045 16.2702 3.35338 16.425 3.50834C16.5799 3.66313 16.7029 3.84695 16.7867 4.04928C16.8706 4.25161 16.9138 4.46848 16.9138 4.68751C16.9138 4.90654 16.8706 5.12341 16.7867 5.32574C16.7029 5.52807 16.5799 5.71189 16.425 5.86668L16.375 5.91668C16.1829 6.11308 16.054 6.36252 16.005 6.63285C15.956 6.90318 15.9891 7.182 16.1 7.43334V7.50001C16.2056 7.74648 16.381 7.95669 16.6046 8.10475C16.8282 8.25282 17.0902 8.33227 17.3583 8.33334H17.5C17.942 8.33334 18.3659 8.50894 18.6785 8.8215C18.9911 9.13406 19.1666 9.55798 19.1666 10C19.1666 10.442 18.9911 10.866 18.6785 11.1785C18.3659 11.4911 17.942 11.6667 17.5 11.6667H17.425C17.1568 11.6677 16.8948 11.7472 16.6713 11.8953C16.4477 12.0433 16.2723 12.2535 16.1666 12.5Z" stroke="currentColor" strokeWidth="2" strokeLinecap="round" strokeLinejoin="round"/>
                </g>
                <defs>
                  <clipPath id="clip0_747_81">
                    <rect width="20" height="20" fill="white"/>
                  </clipPath>
                </defs>
              </svg>
            </NavLink>
          </Header.Buttons>
        </Header>
        <main className="gty-admin-app__main">
          <Routes>
            <Route path="/" element={<Dashboard />} />
            <Route path="/collections" element={<Collections />} />
            <Route path="/collections/:collectionKey" element={<CollectionDetail />} />
            <Route path="/settings" element={<Settings />} />
            <Route path="/chat" element={<Chat />} />
          </Routes>
        </main>
        <div className="gty-admin-version-label">GATEWAY V{window.gatewayAdminScript?.version || '1.1.6'}</div>
      </div>
    </Router>
  );
}

export default App;
