import { HashRouter, Routes, Route, Link } from 'react-router-dom';
import { ExtensionListProvider } from './context/ExtensionListContext';
import { ActiveExtensionProvider } from './context/ActiveExtensionContext';
import { FieldTypesProvider } from './context/FieldTypesContext';
import LeftSidebar from './components/LeftSidebar';
import Breadcrumbs from './components/Breadcrumbs';
import Footer from './components/Footer';
import Dashboard from './pages/Dashboard';
import Settings from './pages/Settings';
import ExtensionCreate from './pages/ExtensionCreate';
import ExtensionView from './pages/ExtensionView';
import CollectionCreate from './pages/CollectionCreate';
import CollectionEditor from './pages/CollectionEditor';
import FieldsEditor from './pages/FieldsEditor';
import FormsEditor from './pages/FormsEditor';
import GridsEditor from './pages/GridsEditor';
import RelationshipsEditor from './pages/RelationshipsEditor';

const SettingsIcon = () => {
  return (
    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" className="text-slate-500">
      <path d="M2.66667 14V9.33331" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M2.66667 6.66667V2" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M8 14V8" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M8 5.33333V2" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M13.3333 14V10.6667" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M13.3333 8V2" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M0.666672 9.33331H4.66667" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M6 5.33331H10" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M11.3333 10.6667H15.3333" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>
  );
};

const App = () => {
  return (
    <ExtensionListProvider>
      <ActiveExtensionProvider>
        <FieldTypesProvider>
          <HashRouter>
          <div id="gateway-exta-app" className="app-bg app-main-margin-fix min-h-screen flex border-l border-slate-600">
            <LeftSidebar />
            <div className="flex-1 flex flex-col">
              <header className="px-8 py-4 flex items-center justify-between border-b border-slate-600">
                <Breadcrumbs />
                <Link to="/settings">
                  <SettingsIcon />
                </Link>
              </header>
            <main className="px-8 py-6 flex-1">
              <Routes>
                <Route path="/extension/create" element={<ExtensionCreate />} />
                <Route path="/extension/:key/collection/create" element={<CollectionCreate />} />
                <Route path="/extension/:key/collection/:collectionKey/fields" element={<FieldsEditor />} />
                <Route path="/extension/:key/collection/:collectionKey/forms" element={<FormsEditor />} />
                <Route path="/extension/:key/collection/:collectionKey/grids" element={<GridsEditor />} />
                <Route path="/extension/:key/collection/:collectionKey/relationships" element={<RelationshipsEditor />} />
                <Route path="/extension/:key/collection/:collectionKey" element={<CollectionEditor />} />
                <Route path="/extension/:key" element={<ExtensionView />} />
                <Route path="/settings" element={<Settings />} />
                <Route path="/" element={<Dashboard />} />
              </Routes>
            </main>
              <Footer />
            </div>
          </div>
        </HashRouter>
        </FieldTypesProvider>
      </ActiveExtensionProvider>
    </ExtensionListProvider>
  );
};

export default App;
