import { Link, useLocation } from 'react-router-dom';
import { useExtensionList } from '../context/ExtensionListContext';
import CollectionMenu from './CollectionMenu';

const SettingsIcon = () => {
  return (
    <svg width="14" height="14" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg" className="text-current">
      <path d="M2.66667 14V9.33331" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M2.66667 6.66667V2" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M8 14V8" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M8 5.33333V2" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M13.3333 14V10.6667" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M13.3333 8V2" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M0.666672 9.33331H4.66667" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M6 5.33331H10" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
      <path d="M11.3333 10.6667H15.3333" stroke="currentColor" strokeLinecap="round" strokeLinejoin="round"/>
    </svg>
  );
};

const Logo = () => {
  return (
    <svg width="142" height="28" viewBox="0 0 71 14" fill="none" xmlns="http://www.w3.org/2000/svg">
      <path d="M13.104 11.11C12.5247 11.11 11.9783 11.0183 11.465 10.835C10.959 10.6443 10.5117 10.3767 10.123 10.032C9.73433 9.68 9.43 9.262 9.21 8.778C8.99 8.28667 8.88 7.744 8.88 7.15C8.88 6.6 8.98633 6.08667 9.199 5.61C9.419 5.13333 9.72333 4.719 10.112 4.367C10.508 4.00767 10.9663 3.729 11.487 3.531C12.0077 3.333 12.5687 3.234 13.17 3.234C13.6247 3.234 14.0573 3.29267 14.468 3.41C14.8787 3.52733 15.2453 3.685 15.568 3.883C15.898 4.081 16.162 4.301 16.36 4.543L15.59 5.368C15.3553 5.16267 15.106 4.99033 14.842 4.851C14.5853 4.70433 14.314 4.59067 14.028 4.51C13.7493 4.42933 13.4633 4.389 13.17 4.389C12.7373 4.389 12.334 4.45867 11.96 4.598C11.5933 4.73733 11.2707 4.93167 10.992 5.181C10.7133 5.43033 10.497 5.72367 10.343 6.061C10.189 6.391 10.112 6.754 10.112 7.15C10.112 7.57533 10.1927 7.96033 10.354 8.305C10.5153 8.64967 10.739 8.94667 11.025 9.196C11.311 9.438 11.6373 9.625 12.004 9.757C12.3707 9.889 12.7593 9.955 13.17 9.955C13.5147 9.955 13.841 9.91467 14.149 9.834C14.4643 9.746 14.7393 9.625 14.974 9.471C15.216 9.317 15.3993 9.13733 15.524 8.932C15.656 8.71933 15.7183 8.49567 15.711 8.261V8.074L15.876 8.261H13.148V7.095H16.954C16.9687 7.19033 16.9797 7.27467 16.987 7.348C16.9943 7.414 16.998 7.47633 16.998 7.535C17.0053 7.58633 17.009 7.63767 17.009 7.689C17.009 8.22433 16.91 8.70467 16.712 9.13C16.514 9.548 16.239 9.90367 15.887 10.197C15.5423 10.4903 15.1317 10.7177 14.655 10.879C14.1857 11.033 13.6687 11.11 13.104 11.11ZM18.2722 11L21.5612 3.3H22.8482L26.1152 11H24.8282L22.7382 6.094C22.7015 6.006 22.6502 5.87767 22.5842 5.709C22.5255 5.533 22.4595 5.346 22.3862 5.148C22.3129 4.95 22.2432 4.763 22.1772 4.587C22.1112 4.40367 22.0599 4.26067 22.0232 4.158L22.3202 4.147C22.2689 4.29367 22.2102 4.455 22.1442 4.631C22.0855 4.807 22.0195 4.98667 21.9462 5.17C21.8802 5.35333 21.8142 5.52933 21.7482 5.698C21.6822 5.85933 21.6235 6.006 21.5722 6.138L19.4932 11H18.2722ZM19.7132 9.13L20.1752 7.986H24.0912L24.4762 9.13H19.7132ZM29.2786 11V4.444H26.8146V3.3H32.9966V4.444H30.4666V11H29.2786ZM35.1151 11V3.3H40.5821V4.444H36.3031V9.856H40.5821V11H35.1151ZM35.6981 7.623V6.479H39.9771V7.623H35.6981ZM44.9522 11L42.3452 3.3H43.6322L45.1722 7.997C45.2235 8.13633 45.2712 8.29033 45.3152 8.459C45.3592 8.62033 45.3995 8.789 45.4362 8.965C45.4802 9.13367 45.5205 9.295 45.5572 9.449C45.5938 9.603 45.6268 9.735 45.6562 9.845L45.2712 9.834C45.3665 9.51867 45.4508 9.251 45.5242 9.031C45.6048 8.811 45.6745 8.61667 45.7332 8.448C45.7992 8.27933 45.8578 8.129 45.9092 7.997L47.3172 4.631H48.4062L49.7702 7.986C49.8508 8.16933 49.9278 8.36367 50.0012 8.569C50.0745 8.767 50.1405 8.965 50.1992 9.163C50.2652 9.35367 50.3202 9.54433 50.3642 9.735L50.0232 9.812C50.0598 9.64333 50.0892 9.50033 50.1112 9.383C50.1405 9.25833 50.1662 9.14467 50.1882 9.042C50.2175 8.932 50.2468 8.82567 50.2762 8.723C50.3055 8.62033 50.3422 8.50667 50.3862 8.382C50.4302 8.25733 50.4778 8.11433 50.5292 7.953L52.1352 3.3H53.4112L50.6722 11H49.8472L47.7352 6.039L47.8782 6.083L45.7992 11H44.9522ZM54.1081 11L57.3971 3.3H58.6841L61.9511 11H60.6641L58.5741 6.094C58.5375 6.006 58.4861 5.87767 58.4201 5.709C58.3615 5.533 58.2955 5.346 58.2221 5.148C58.1488 4.95 58.0791 4.763 58.0131 4.587C57.9471 4.40367 57.8958 4.26067 57.8591 4.158L58.1561 4.147C58.1048 4.29367 58.0461 4.455 57.9801 4.631C57.9215 4.807 57.8555 4.98667 57.7821 5.17C57.7161 5.35333 57.6501 5.52933 57.5841 5.698C57.5181 5.85933 57.4595 6.006 57.4081 6.138L55.3291 11H54.1081ZM55.5491 9.13L56.0111 7.986H59.9271L60.3121 9.13H55.5491ZM65.4525 11V7.315L65.5845 7.986L62.0645 3.3H63.5825L66.2115 6.897L65.9475 6.875L68.4005 3.3H69.8085L66.5195 7.931L66.6405 7.227V11H65.4525Z" fill="white"/>
      <rect x="7" y="5" width="1" height="1" transform="rotate(90 7 5)" fill="white"/>
      <rect x="5" y="5" width="1" height="1" transform="rotate(90 5 5)" fill="white"/>
      <rect x="5" y="7" width="1" height="1" transform="rotate(90 5 7)" fill="white"/>
      <rect x="3" y="7" width="1" height="1" transform="rotate(90 3 7)" fill="white"/>
      <rect x="1" y="7" width="1" height="1" transform="rotate(90 1 7)" fill="white"/>
      <rect x="1" y="9" width="1" height="1" transform="rotate(90 1 9)" fill="white"/>
      <rect x="3" y="9" width="1" height="1" transform="rotate(90 3 9)" fill="white"/>
    </svg>
  );
};

const LeftSidebar = () => {
  const { extensions, loading } = useExtensionList();
  const location = useLocation();

  if (loading) {
    return (
      <aside className="w-64 p-4 border-r border-slate-600 flex flex-col h-screen">
        <div className="flex-1">
          <Link to="/" className="block mb-6">
            <Logo />
          </Link>
          <div className="text-gray-500">Loading...</div>
        </div>
        <div className="pt-4">
          <Link
            to="/settings"
            className="flex items-center gap-2 px-3 py-2 rounded-lg transition-colors hover:bg-neutral-800 !text-slate-400"
          >
            <SettingsIcon />
            Settings
          </Link>
        </div>
      </aside>
    );
  }

  return (
    <aside className="w-64 p-4 border-r border-slate-600 flex flex-col h-screen">
      <div className="flex-1">
        <Link to="/" className="block mb-6">
          <Logo />
        </Link>

        <CollectionMenu />

        <div className="flex items-center justify-between mb-4">
          <h2 className="extension-heading text-lg font-semibold">
            Extensions ({extensions.length})
          </h2>
          <Link
            to="/extension/create"
            className="px-3 py-1 text-sm bg-black !text-white rounded-lg hover:bg-gray-800 transition-colors"
          >
            + New
          </Link>
        </div>

        {extensions.length === 0 ? (
          <div className="text-gray-500">—</div>
        ) : (
          <nav className="space-y-1">
            {extensions.map((extension) => {
              const isActive = location.pathname.startsWith(`/extension/${extension.key}`);
              return (
                <Link
                  key={extension.key}
                  to={`/extension/${extension.key}`}
                  className={`extension-link block px-3 py-2 rounded-lg transition-colors ${
                    isActive ? 'active' : ''
                  }`}
                >
                  {extension.title || extension.key}
                </Link>
              );
            })}
          </nav>
        )}
      </div>

      <div className="pt-4">
        <Link
          to="/settings"
          className={`flex items-center gap-2 px-3 py-2 rounded-lg transition-colors ${
            location.pathname === '/settings'
              ? 'bg-neutral-800 !text-slate-200'
              : 'hover:bg-neutral-800 !text-slate-400'
          }`}
        >
          <SettingsIcon />
          Settings
        </Link>
      </div>
    </aside>
  );
};

export default LeftSidebar;
