import './style.css';

/**
 * SelectFilter Component
 * HTML5 select box filter with configurable options
 *
 * @param {Object} props
 * @param {Array} props.choices - Array of {value, label} objects
 * @param {string} props.value - Current selected value
 * @param {Function} props.onChange - Change handler
 * @param {string} props.label - Label text for the select
 * @param {string} props.placeholder - Placeholder option text
 * @param {string} props.className - Additional CSS classes
 */
const SelectFilter = ({
  choices = [],
  value = '',
  onChange,
  label = '',
  placeholder = 'Select...',
  className = '',
}) => {
  const handleChange = (e) => {
    if (onChange) {
      onChange(e.target.value);
    }
  };

  return (
    <div className={['select-filter', className].filter(Boolean).join(' ')}>
      {label && (
        <label className="select-filter__label">
          {label}
        </label>
      )}
      <select
        value={value}
        onChange={handleChange}
        className="select-filter__control"
      >
        <option value="">{placeholder}</option>
        {choices.map((choice) => (
          <option key={choice.value} value={choice.value}>
            {choice.label}
          </option>
        ))}
      </select>
    </div>
  );
};

export default SelectFilter;
