<?php

declare(strict_types=1);

namespace Anthropic\Messages;

use Anthropic\Core\Attributes\Api;
use Anthropic\Core\Concerns\SdkModel;
use Anthropic\Core\Contracts\BaseModel;

/**
 * @phpstan-type citation_search_result_location_param = array{
 *   citedText: string,
 *   endBlockIndex: int,
 *   searchResultIndex: int,
 *   source: string,
 *   startBlockIndex: int,
 *   title: string|null,
 *   type: string,
 * }
 */
final class CitationSearchResultLocationParam implements BaseModel
{
    /** @use SdkModel<citation_search_result_location_param> */
    use SdkModel;

    #[Api]
    public string $type = 'search_result_location';

    #[Api('cited_text')]
    public string $citedText;

    #[Api('end_block_index')]
    public int $endBlockIndex;

    #[Api('search_result_index')]
    public int $searchResultIndex;

    #[Api]
    public string $source;

    #[Api('start_block_index')]
    public int $startBlockIndex;

    #[Api]
    public ?string $title;

    /**
     * `new CitationSearchResultLocationParam()` is missing required properties by the API.
     *
     * To enforce required parameters use
     * ```
     * CitationSearchResultLocationParam::with(
     *   citedText: ...,
     *   endBlockIndex: ...,
     *   searchResultIndex: ...,
     *   source: ...,
     *   startBlockIndex: ...,
     *   title: ...,
     * )
     * ```
     *
     * Otherwise ensure the following setters are called
     *
     * ```
     * (new CitationSearchResultLocationParam)
     *   ->withCitedText(...)
     *   ->withEndBlockIndex(...)
     *   ->withSearchResultIndex(...)
     *   ->withSource(...)
     *   ->withStartBlockIndex(...)
     *   ->withTitle(...)
     * ```
     */
    public function __construct()
    {
        $this->initialize();
    }

    /**
     * Construct an instance from the required parameters.
     *
     * You must use named parameters to construct any parameters with a default value.
     */
    public static function with(
        string $citedText,
        int $endBlockIndex,
        int $searchResultIndex,
        string $source,
        int $startBlockIndex,
        ?string $title,
    ): self {
        $obj = new self;

        $obj->citedText = $citedText;
        $obj->endBlockIndex = $endBlockIndex;
        $obj->searchResultIndex = $searchResultIndex;
        $obj->source = $source;
        $obj->startBlockIndex = $startBlockIndex;
        $obj->title = $title;

        return $obj;
    }

    public function withCitedText(string $citedText): self
    {
        $obj = clone $this;
        $obj->citedText = $citedText;

        return $obj;
    }

    public function withEndBlockIndex(int $endBlockIndex): self
    {
        $obj = clone $this;
        $obj->endBlockIndex = $endBlockIndex;

        return $obj;
    }

    public function withSearchResultIndex(int $searchResultIndex): self
    {
        $obj = clone $this;
        $obj->searchResultIndex = $searchResultIndex;

        return $obj;
    }

    public function withSource(string $source): self
    {
        $obj = clone $this;
        $obj->source = $source;

        return $obj;
    }

    public function withStartBlockIndex(int $startBlockIndex): self
    {
        $obj = clone $this;
        $obj->startBlockIndex = $startBlockIndex;

        return $obj;
    }

    public function withTitle(?string $title): self
    {
        $obj = clone $this;
        $obj->title = $title;

        return $obj;
    }
}
